#define soc_file_receive
/* soc_file_receive( soc, filename, size );
Receives a file.

soc     - The connection to receive from.
filename- The filename which the file will be written to.
size    - The filesize.
*/

var ff, size;
// If the file doesn't exist, you can't create it directly in binary.
if(!file_exists(argument1)) {
  // So we first create it in text.
  ff=file_text_open_write(argument1);
  file_text_close(ff);
}

// Then open it as binary.
ff=file_bin_open(argument1, 1);
size=0;

// While we don't have received enough bytes...
while(size<argument2) {
  // Check if there are new bytes
  if(soc_peek(argument0, SOC_BYTE)) {
    // If so, write them to the file.
    file_bin_write_byte(ff, soc_receive(argument0, SOC_BYTE));
    size+=1;
  } else {
    // Else, wait a little while.
    sleep(50);
  }
}

// Close the file.
file_bin_close(ff);
return true;

#define soc_file_send
/* soc_file_send( soc, filename);
Sends a file.

soc     - The connection to receive from.
filename- The file to send.
*/

var ff, size, pos, buf;
// If the file doesn't exist, return false.
if(!file_exists(argument1)) {
  return false;
}

// Open the file.
ff=file_bin_open(argument1, 0);
// And get the size of it.
size=file_bin_size(ff);

// While we didn't send all bytes...
while(size>0) {
  // Create a buffer.
  buf=buffer_create();
  // Add up to 1024 bytes.
  for(pos=0; pos<min(size, 1024); pos+=1) {
    buffer_add(buf, SOC_BYTE, file_bin_read_byte(ff));
  }
  // Send the buffer.
  soc_send(argument0, buf);
  // And destroy it.
  buffer_destroy(buf);
  size-=min(size, 1024);
}

// Close the file.
file_bin_close(ff);
return true;


#define file_size
/* file_size( filename );
Returns the filesize of a file.

filename- The file which size will be returned.
*/

var ff, size;
// First we check if the file exists...
if(file_exists(argument0)) {
  // If it does, open it.
  ff=file_bin_open(argument0, 0);
  // And get the file size.
  size=file_bin_size(ff);
  // Close the file.
  file_bin_close(ff);
  // And return the file size.
  return size;
}
// It doesn't exist, so return 0.
return 0;
