#define buffer_add
/* buffer_add( buffer, datatype, number, string);
Adds data to a buffer.

buffer    - The buffer to which the data is added.
datatype  - The datatype of the number, eg SOC_BYTE.
number    - The number to be added, or in case of a string, the size of the string.
string    - Only when adding a string, the string to be added.
*/

return external_call(global.___SOC_BUFFER_ADD, argument0, argument1, argument2, string(argument3));

#define buffer_create
/* buffer_create();
Creates a new buffer, and returns its id.
*/

return external_call(global.___SOC_BUFFER_CREATE);

#define buffer_destroy
/* buffer_destroy( buffer);
Destroys the buffer, and freeing memory it is using.

buffer    - The buffer to destroy.
*/

return external_call(global.___SOC_BUFFER_DESTROY, argument0);

#define internet_status
/* internet_status( );
Returns true when the computer is connected to internet.
*/

return external_call(global.___INTERNET_STATUS);

#define sha256
/* sha256( str );
Creates a SHA-256 hash based on the data in str.

str   - The string to hash.
*/

return external_call(global.___SHA256, argument0);
#define soc_accept
/* soc_accept( soc );
Accepts a new socket on a current listening socket.
Returns 0 when there is no new connection, otherwise it returns the new id.

soc   - The listening socket.
*/

return external_call(global.___SOC_ACCEPT, argument0);

#define soc_create
/* soc_create( mode, port, ip );
Creates a new socket, and returns its id, or 0 when failed.

mode    - The mode the socket should run in.
port    - The port number of the new socket.
ip      - The ip address to connect to, in case of TCP sockets,
          or the multicast ip to join in case of UDP (225.0.0.0 - 239.255.255.255).
*/

return external_call(global.___SOC_CREATE, argument0, argument1, string(argument2));

#define soc_destroy
/* soc_destroy( soc );
Destroys a connection.

soc     - The socket to destroy.
*/

return external_call(global.___SOC_DESTROY, argument0);

#define soc_valid
/* soc_valid( soc );
Returns true when the connection is still open, or false if the connection
has been closed.

soc     - The socket to check.
*/

return external_call(global.___SOC_VALID, argument0);

#define soc_free
/* soc_free();
Frees the SOC dll.
*/

external_free(global.___SOC_DLL);
global.___SOC_DLL="";
#define soc_init
/* soc_init();
Inits all SOC functions. This function should be called before anything else.
*/

if(variable_global_exists("___SOC_DLL")) {
  if(global.___SOC_DLL!="") {
    return false;
  }
}
global.___SOC_DLL="soc.dll";

global.___SOC_CREATE=external_define(global.___SOC_DLL,"SocCreate", dll_cdecl, ty_real, 3, ty_real, ty_real, ty_string);
global.___SOC_ACCEPT=external_define(global.___SOC_DLL,"SocAccept", dll_cdecl, ty_real, 1, ty_real);
global.___SOC_DESTROY=external_define(global.___SOC_DLL,"SocDestroy", dll_cdecl, ty_real, 1, ty_real);
global.___SOC_VALID=external_define(global.___SOC_DLL,"SocValid", dll_cdecl, ty_real, 1, ty_real);

global.___SOC_BUFFER_CREATE=external_define(global.___SOC_DLL,"BufferCreate", dll_cdecl, ty_real, 0);
global.___SOC_BUFFER_DESTROY=external_define(global.___SOC_DLL,"BufferDestroy", dll_cdecl, ty_real, 1, ty_real);
global.___SOC_BUFFER_ADD=external_define(global.___SOC_DLL,"BufferAdd", dll_cdecl, ty_real, 4, ty_real, ty_real, ty_real, ty_string);

global.___SOC_PEEK=external_define(global.___SOC_DLL,"SocPeek", dll_cdecl, ty_real, 3, ty_real, ty_real, ty_real);

global.___SOC_SEND=external_define(global.___SOC_DLL,"SocSendBuffer", dll_cdecl, ty_real, 4, ty_real, ty_real, ty_real, ty_string);
global.___SOC_SEND_TOKEN=external_define(global.___SOC_DLL,"SocSendToken", dll_cdecl, ty_real, 4, ty_real, ty_string, ty_real, ty_string);

global.___SOC_RECEIVE_REAL=external_define(global.___SOC_DLL,"SocReceiveReal", dll_cdecl, ty_real, 2, ty_real, ty_real);
global.___SOC_RECEIVE_STRING=external_define(global.___SOC_DLL,"SocReceiveString", dll_cdecl, ty_string, 3, ty_real, ty_real, ty_real);
global.___SOC_RECEIVE_TOKEN=external_define(global.___SOC_DLL,"SocReceiveToken", dll_cdecl, ty_string, 2, ty_real, ty_string);

global.___SOC_IPADDRESS=external_define(global.___SOC_DLL,"SocIpAddress", dll_cdecl, ty_string, 1, ty_real);
global.___SHA256=external_define(global.___SOC_DLL, "Sha256", dll_cdecl, ty_string, 1, ty_string);
global.___INTERNET_STATUS=external_define(global.___SOC_DLL, "InternetStatus", dll_cdecl, ty_real, 0);

global.___MT_SRAND=external_define(global.___SOC_DLL, "MersenneSetRand", dll_cdecl, ty_real, 1, ty_real);
global.___MT_RAND=external_define(global.___SOC_DLL, "MersenneRand", dll_cdecl, ty_real, 1, ty_real);

return true;


#define soc_ipaddress
/* soc_ipaddress( soc );
Returns the local ipaddress in case called without arguments,
returns the ip connected to in case of a TCP socket, or
the ipaddress from which the last packet has been received
when soc is a UDP socket.

soc   - The connection.
*/

return external_call(global.___SOC_IPADDRESS, argument0);


#define soc_peek
/* soc_peek( soc, datatype, size );
Returns true when data is avaiable in the buffer.

soc     - The connection to check.
type    - Data type which is checked.
size    - The size of the string, in case of SOC_STRING as datatype.
*/

return external_call(global.___SOC_PEEK, argument0, argument1, argument2);


#define soc_receive
/* soc_receive( soc, datatype, size );
Receives data from a socket.

soc   - The connection from which the data will be received.
type  - The datatype of the data.
size  - The size of the string.
*/

if(argument1==SOC_STRING) {
  return external_call(global.___SOC_RECEIVE_STRING, argument0, argument1, argument2);
}
return external_call(global.___SOC_RECEIVE_REAL, argument0, argument1);


#define soc_receive_token
/* soc_receive_token( soc, delimiter );
Receives a token from a socket.

soc       - The connection from which the token will be received.
delimiter - The delimiter of the token, the default is chr(13) + chr(10).
*/

if(is_real(argument1)) {
  argument1=chr(13)+chr(10);
}
return external_call(global.___SOC_RECEIVE_TOKEN, argument0, argument1);


#define soc_send
/* soc_send( soc, buffer, port, ip );
Sends the data in a buffer.

soc     - The connection to send over.
buffer  - The buffer to send.
port    - Only for UDP sockets, the target port.
ip      - Only for UDP sockets, the target ip.
*/

return external_call(global.___SOC_SEND, argument0, argument1, argument2, string(argument3));

#define soc_send_token
/* soc_send_token( soc, token, delimiter, port, ip );
Sends a token to a socket.

soc       - The connection to send over.
string    - The token to send.
delimiter - The delimiter of the token, the default is chr(13) + chr(10).
port      - Only for UDP sockets, the target port.
ip        - Only for UDP sockets, the target ip.
*/

if(is_real(argument2)) {
  argument2=chr(13)+chr(10);
}
return external_call(global.___SOC_SEND_TOKEN, argument0, argument1+argument2, argument3, string(argument4));


